<?php

namespace App\Enums\Product;

use App\Models\Book;
use App\Models\Course;
use App\Models\Event;

enum ProductType: string
{
    case EVENT = "EVENT";
    case E_BOOK = "E-BOOK";
    case COURSE = "COURSE";



    public static function getProductType($type): string
    {

        return match ($type) {
            get_class(new Course()) => self::COURSE->value,
            get_class(new Event()) => self::EVENT->value,
            get_class(new Book()) => self::E_BOOK->value,
            null => self::E_BOOK->value,
        };
    }

}
