<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Illuminate\Database\Eloquent\Builder;

class Event extends BaseModel implements HasMedia
{
    use HasFactory;
    use HasUuids;
    use InteractsWithMedia;

    protected $casts = [
        'status' => 'boolean',
        'is_featured' => 'boolean',
        'price' => 'float',
    ];

    protected $fillable = [
        'name_ar',
        'name_en',
        'slug',
        'price',
        'sale_price',
        'description_ar',
        'description_en',
        'section_one_title_en',
        'section_one_title_ar',
        'section_one_description_en',
        'section_one_description_ar',
        'section_two_title_en',
        'section_two_title_ar',
        'section_two_description_en',
        'section_two_description_ar',
        'section_three_title_en',
        'section_three_title_ar',
        'section_three_description_en',
        'section_three_description_ar',
        'status',
        'is_featured',
        'category_id',
    ];

    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class);
    }

    /**
     * Apply all relevant Sizes filters
     *
     * @param Builder $query
     * @return Builder
     */
    public function scopeIsFeatured(Builder $query): Builder
    {
        return $query->where('is_featured', true);
    }

    /**
     * Apply all relevant Sizes filters
     *
     * @param Builder $query
     * @return Builder
     */
    public function scopeIsNotFeatured(Builder $query): Builder
    {
        return $query->where('is_featured', false);
    }

    public function order(): MorphOne
    {
        return $this->morphOne(Order::class, 'productable');
    }
}
