<?php

namespace App\Services\Website\AboutUs;

use App\DTOs\Api\AboutUs\GetAboutUsDTO;
use App\Repositories\Interfaces\AboutUsRepositoryInterface;
use Exception;
use Illuminate\Database\Eloquent\Collection;

class GetAboutUsService
{
    private GetAboutUsDTO $dto;

    /**
     * @param AboutUsRepositoryInterface $pageRepository
     */
    public function __construct(
        private readonly AboutUsRepositoryInterface $pageRepository
    )
    {
    }

    /**
     * @param GetAboutUsDTO $dto
     * @return self
     */
    final public function setDto(GetAboutUsDTO $dto): self
    {
        $this->dto = $dto;
        return $this;
    }

    /**
     * @throws Exception
     */
    final public function execute(): ?Collection
    {
        return $this->pageRepository->get($this->dto);
    }

}
